/*
 * Decompiled with CFR 0.152.
 */
package com.dao;

import com.dto.InvoiceDetailDto;
import com.dto.LoginDto;
import com.utility.ConvertStr;
import com.utility.DbConnection;
import com.utility.NetworkUtils;
import com.utility.TncException;
import com.utility.TncExceptionMessages;
import java.util.Collection;
import java.util.List;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;

public class SerialDao {
    private final JdbcTemplate jdbc;
    private final InvoiceDetailDto dtl;
    private SqlRowSet rs;
    private final String artName;
    private final String userAddress;

    SerialDao(DbConnection dbConnection, InvoiceDetailDto dtl, LoginDto login) {
        this.jdbc = dbConnection.getJdbcTemplate(login);
        this.dtl = dtl;
        this.artName = (String)this.jdbc.queryForObject(" SELECT A_NAME FROM ARTICLE WHERE A_CODE = ?", String.class, new Object[]{dtl.getProductid()});
        this.userAddress = NetworkUtils.getHostNameAndAddress();
    }

    void assertMustHaveSerial() throws TncException {
        if (ConvertStr.isNullOrEmpty((Collection)this.dtl.getSerials()) && this.checkMandatorySerial()) {
            throw new TncException(TncExceptionMessages.MANDATORY_SERIAL_FOR_PRODUCT_PLACEHOLDER.setArgs(new Object[]{this.artName}));
        }
    }

    void assertAnbSerExistence() throws TncException {
        if (ConvertStr.isNullOrEmpty((Collection)this.dtl.getSerials())) {
            return;
        }
        List serials = this.getSerialsForArticle();
        switch (this.dtl.getType()) {
            case "F": 
            case "X": {
                if (!ConvertStr.isNullOrEmpty((Collection)serials) && serials.size() == this.dtl.getSerials().size()) break;
                throw new TncException(TncExceptionMessages.NO_SERIAL_EXIST_FOR_PLACEHOLDER_PRODUCT.setArgs(new Object[]{this.artName}));
            }
            case "K": 
            case "Y": {
                if (ConvertStr.isNullOrEmpty((Collection)serials)) break;
                throw new TncException(TncExceptionMessages.DUPLICATE_SERIALS_FOR_PLACEHOLDER_PRODUCT.setArgs(new Object[]{this.artName}));
            }
        }
    }

    private boolean checkMandatorySerial() {
        this.rs = this.jdbc.queryForRowSet(" SELECT SerialUsage FROM ARTICLE WHERE A_CODE = ?", new Object[]{this.dtl.getProductid()});
        if (this.rs.next()) {
            return this.rs.getBoolean(1);
        }
        return false;
    }

    private List<String> getSerialsForArticle() {
        this.rs = this.jdbc.queryForRowSet(" SELECT COUNT(A_SERIAL) CNT FROM ANB_SER WHERE A_CODE = ? AND A_SERIAL IN (" + ConvertStr.commaBindStringsWithQuotes((Collection)this.dtl.getSerials()) + ")", new Object[]{ConvertStr.decrypt((String)this.dtl.getProducterpcode())});
        this.rs.next();
        return this.rs.getInt("CNT") == 0 ? null : this.dtl.getSerials();
    }

    void buyOrSellGivenSerials(String invoiceCode) {
        if (this.dtl.getType().equals("K") || this.dtl.getType().equals("Y")) {
            this.buyGivenSerials(invoiceCode);
        } else if (this.dtl.getType().equals("F") || this.dtl.getType().equals("X")) {
            this.sellGivenSerials(invoiceCode);
        }
    }

    private void buyGivenSerials(String invoiceCode) {
        for (String serial : this.dtl.getSerials()) {
            this.insertAnbSer(serial);
            this.insertFacSer(serial, invoiceCode);
        }
    }

    private void sellGivenSerials(String invoiceCode) {
        for (String serial : this.dtl.getSerials()) {
            this.updateAnbSer(serial);
            this.insertFacSer(serial, invoiceCode);
            this.deleteAnbSer(serial);
        }
    }

    private void deleteAnbSer(String serial) {
        this.jdbc.update(" DELETE FROM ANB_SER WHERE A_CODE = ? AND UsedByUser = ? AND A_SERIAL = ? AND [INDEX] = 1", new Object[]{this.dtl.getProductid(), this.userAddress, serial});
    }

    private void insertAnbSer(String serial) {
        this.jdbc.update(" INSERT INTO ANB_SER (A_Code, A_Serial, Un_Used, A_Index,  [Index],Guarantor,BuyDate,GuaranteeDuration,Comment, UseKhadamat)  VALUES (?, ?, 0, 1, 0, '', ?, 0, '', 0)", new Object[]{this.dtl.getProductid(), serial, ConvertStr.getCurrentDateStringNoTime()});
    }

    private void updateAnbSer(String serial) {
        this.jdbc.update(" UPDATE ANB_SER SET [INDEX] = 1, USEDBYUSER = ? WHERE A_CODE = ? AND A_SERIAL = ? ", new Object[]{this.userAddress, this.dtl.getProductid(), serial});
    }

    private void insertFacSer(String serial, String invoiceCode) {
        this.jdbc.update(" INSERT INTO FAC_SER (Fac_Code, Fac_Type, A_Code, A_Serial, A_Index, Bild_or_tajzieh,  [Index], Guarantor, BuyDate, GuaranteeDuration, Comment) VALUES (?, ?, ?, ?, 1, N' ', 0, N'', ?, 0, N'')", new Object[]{invoiceCode, this.dtl.getType(), this.dtl.getProductid(), serial, ConvertStr.getCurrentDateStringNoTime()});
    }
}

